% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/restimizeapi.R
\name{GetCompanyReleases}
\alias{GetCompanyReleases}
\title{Returns the past financial releases for the specified company by the ticker,
for the specified fiscal year, and quarter.}
\usage{
GetCompanyReleases(ticker, year = NULL, quarter = NULL)
}
\arguments{
\item{ticker}{The Estimize ticker -- for example "MSFT".}

\item{year}{A four-digit year -- for example 1999.}

\item{quarter}{A numeric value between 1 and 4 inclusive; note that if the
 quarter is used the year must also be set as well.}
}
\value{
The company releases as a data frame.
}
\description{
Returns the past financial releases for the specified company by the ticker,
for the specified fiscal year, and quarter.
}
\examples{
\dontrun{
 result <- GetCompanyReleases ("MSFT")
 result <- GetCompanyReleases ("MSFT", 2009)
 result <- GetCompanyReleases ("MSFT", 2009, 2)
 }
}

