% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate_claims.R
\name{truncate_claims}
\alias{truncate_claims}
\title{Truncate claims data subject to reporting delay}
\usage{
truncate_claims(data, accident, delay, time, .report_col = "report")
}
\arguments{
\item{data}{Full claims data including IBNR}

\item{accident}{Accident times. May be an unquoted column name from \code{data}.}

\item{delay}{Reporting delays. May be an unquoted column name from \code{data}.}

\item{time}{Observation time (scalar number or one per claim).
Claims with \code{accident + delay > time} will be truncated.
Set \code{time = Inf} to only compute reporting times and perform no truncation.}

\item{.report_col}{\code{NULL} or a column name to store the reporting time
\code{report = accident + delay}.}
}
\value{
Truncated \code{data}.
The reporting time is stored in a colnumn named by \code{.report_col} unless
\code{.report_col} is \code{NULL}.
If both \code{.report_col} is \code{NULL} and \code{time} contains only \code{Inf}s,
a warning will be issued since \code{data} will be
returned unchanged and no work will be done.
}
\description{
Truncate claims data subject to reporting delay
}
\examples{
claims_full <- data.frame(
  acc = runif(100),
  repdel = rexp(100)
)
tau <- 2.0
truncate_claims(claims_full, acc, repdel, tau)

}
