% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last_reservoir_state.R
\name{last_reservoir_state}
\alias{last_reservoir_state}
\title{Extract the Last Reservoir State for Each Input Sequence}
\usage{
last_reservoir_state(node, X)
}
\arguments{
\item{node}{A trained reservoir network model (from the `reservoirnet` package).}

\item{X}{A list of input sequences, where each element is a matrix of input data.}
}
\value{
A list containing the last reservoir state for each input sequence.
Each element of the returned list is a matrix representing the final state of the reservoir
for a corresponding input sequence in `X`.
}
\description{
This function computes the reservoir states for a given set of input sequences
and extracts the final state of the reservoir for each sequence.
}
\examples{
\dontrun{
library(reservoirnet)
node <- reservoirnet::createNode("Reservoir", units = 100,
                                 lr=0.1, sr=0.9,
                                 seed = 1)
X <- list(matrix(runif(100), ncol = 1), matrix(runif(200), ncol = 1))  # Example input sequences
last_states <- last_reservoir_state(node, X)
print(last_states)
}

}
