% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_addsupp.R
\name{ru_addsupp}
\alias{ru_addsupp}
\title{Cobmine an SDTM domain with its corresponding Supplemental data set}
\usage{
ru_addsupp(dsetin, dsetinsupp)
}
\arguments{
\item{dsetin}{Incoming data frame to have supplemental data added.}

\item{dsetinsupp}{The supplemental data set to add.}
}
\value{
The original SDTM data set with its supplemental data appended as new variables.
}
\description{
Pass in an SDTM data frame along with its Supplemental version and they will be combined.
}
\examples{
library(repfun)
library(knitr)
ae <- repfun::ae
suppae <- repfun::suppae
aesupp <- repfun::ru_addsupp(dsetin=ae,dsetinsupp=suppae)
knitr::kable(head(aesupp,5), caption = "SDTM.AE combined with SDTM.SUPPAE")

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
