% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remoteTS-mapTS_methods.R
\name{print.remoteTS}
\alias{print.remoteTS}
\alias{summary.remoteTS}
\alias{print.mapTS}
\alias{summary.mapTS}
\alias{smry_funM}
\alias{smry_funV}
\title{S3 print method for remoteTS class}
\usage{
\method{print}{remoteTS}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{summary}{remoteTS}(
  object,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{mapTS}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{mapTS}(
  object,
  digits = max(3L, getOption("digits") - 3L),
  CL = 0.95,
  na.rm = TRUE,
  ...
)

smry_funM(x, CL = 0.95, na.rm = TRUE)

smry_funV(x, CL = 0.95, na.rm = TRUE)
}
\arguments{
\item{x}{numeric matrix}

\item{digits}{significant digits to show}

\item{signif.stars}{logical, passed to \code{stats::printCoefmat}}

\item{..., }{additional parameters passed to further print methods}

\item{object}{mapTS object}

\item{CL}{confidence level (default = .95)}

\item{na.rm}{logical, should observations with NA be removed?}
}
\value{
returns formatted output

returns formatted output, including summary stats

returns formatted output

returns formatted summary stats

summary statistics for each column including quartiles, mean, and
upper and lower confidence levels (given by CL)

summary statistics including quartiles, mean, and upper and lower
confidence levels (given by CL)
}
\description{
S3 print method for remoteTS class

S3 summary method for remoteTS class

S3 print method for mapTS class

S3 summary method for mapTS class

helper summary function (matrix)

helper summary function (vector)
}
\examples{
# simulate dummy data
 time.points = 9 # time series length
 map.width = 5 # square map width
 coords = expand.grid(x = 1:map.width, y = 1:map.width) # coordinate matrix
 ## create empty spatiotemporal variables:
 X <- matrix(NA, nrow = nrow(coords), ncol = time.points) # response
 Z <- matrix(NA, nrow = nrow(coords), ncol = time.points) # predictor
 # setup first time point:
 Z[, 1] <- .05*coords[,"x"] + .2*coords[,"y"]
 X[, 1] <- .5*Z[, 1] + rnorm(nrow(coords), 0, .05) #x at time t
 ## project through time:
 for(t in 2:time.points){
   Z[, t] <- Z[, t-1] + rnorm(map.width^2)
   X[, t] <- .2*X[, t-1] + .1*Z[, t] + .05*t + rnorm(nrow(coords), 0 , .25)
 }

 ## Pixel CLS
 tmp.df = data.frame(x = X[1, ], t = nrow(X), z = Z[1, ])
 CLS <- fitCLS(x ~ z, data = tmp.df)
 print(CLS)
 summary(CLS)
 residuals(CLS)
 coef(CLS)
 logLik(CLS)
 fitted(CLS)
 # plot(CLS) # doesn't work

 ## Pixel AR
 AR <- fitAR(x ~ z, data = tmp.df)
 print(AR)
 summary(AR)
 coef(AR)
 residuals(AR)
 logLik(AR)
 fitted(AR)
 # plot(AR) # doesn't work

 ## Map CLS
 CLS.map <- fitCLS_map(X, coords, y ~ Z, X.list = list(Z = Z), lag.x = 0, resids.only = TRUE)
 print(CLS.map)
 summary(CLS.map)
 residuals(CLS.map)
 # plot(CLS.map)# doesn't work

 CLS.map <- fitCLS_map(X, coords, y ~ Z, X.list = list(Z = Z), lag.x = 0, resids.only = FALSE)
 print(CLS.map)
 summary(CLS.map)
 coef(CLS.map)
 residuals(CLS.map)
 # logLik(CLS.map) # doesn't work
 fitted(CLS.map)
 # plot(CLS.map) # doesn't work

 ## Map AR
 AR.map <- fitAR_map(X, coords, y ~ Z, X.list = list(Z = Z), resids.only = TRUE)
 print(AR.map)
 summary(AR.map)
 residuals(AR.map)
 # plot(AR.map)# doesn't work

 AR.map <- fitAR_map(X, coords, y ~ Z, X.list = list(Z = Z), resids.only = FALSE)
 print(AR.map)
 summary(AR.map)
 coef(AR.map)
 residuals(AR.map)
 # logLik(AR.map) # doesn't work
 fitted(AR.map)
 # plot(AR.map) # doesn't work

}
