% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_create_site}
\alias{lemmy_create_site}
\title{Create your site.}
\usage{
lemmy_create_site(
  name,
  sidebar = NULL,
  description = NULL,
  icon = NULL,
  banner = NULL,
  enable_downvotes = NULL,
  enable_nsfw = NULL,
  community_creation_admin_only = NULL,
  require_email_verification = NULL,
  application_question = NULL,
  private_instance = NULL,
  default_theme = NULL,
  default_post_listing_type = NULL,
  legal_information = NULL,
  application_email_admins = NULL,
  hide_modlog_mod_names = NULL,
  discussion_languages = NULL,
  slur_filter_regex = NULL,
  actor_name_max_length = NULL,
  rate_limit_message = NULL,
  rate_limit_message_per_second = NULL,
  rate_limit_post = NULL,
  rate_limit_post_per_second = NULL,
  rate_limit_register = NULL,
  rate_limit_register_per_second = NULL,
  rate_limit_image = NULL,
  rate_limit_image_per_second = NULL,
  rate_limit_comment = NULL,
  rate_limit_comment_per_second = NULL,
  rate_limit_search = NULL,
  rate_limit_search_per_second = NULL,
  federation_enabled = NULL,
  federation_debug = NULL,
  captcha_enabled = NULL,
  captcha_difficulty = NULL,
  allowed_instances = NULL,
  blocked_instances = NULL,
  taglines = NULL,
  registration_mode = NULL,
  auth,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{name}{A character value.}

\item{sidebar}{(Optional) A character value.}

\item{description}{(Optional) A character value.}

\item{icon}{(Optional) A character value.}

\item{banner}{(Optional) A character value.}

\item{enable_downvotes}{(Optional) A logical value.}

\item{enable_nsfw}{(Optional) A logical value.}

\item{community_creation_admin_only}{(Optional) A logical value.}

\item{require_email_verification}{(Optional) A logical value.}

\item{application_question}{(Optional) A character value.}

\item{private_instance}{(Optional) A logical value.}

\item{default_theme}{(Optional) A character value.}

\item{default_post_listing_type}{(Optional) One of "All", "Local", or "Subscribed".}

\item{legal_information}{(Optional) A character value.}

\item{application_email_admins}{(Optional) A logical value.}

\item{hide_modlog_mod_names}{(Optional) A logical value.}

\item{discussion_languages}{(Optional) A numeric vector.}

\item{slur_filter_regex}{(Optional) A character value.}

\item{actor_name_max_length}{(Optional) A numeric value.}

\item{rate_limit_message}{(Optional) A numeric value.}

\item{rate_limit_message_per_second}{(Optional) A numeric value.}

\item{rate_limit_post}{(Optional) A numeric value.}

\item{rate_limit_post_per_second}{(Optional) A numeric value.}

\item{rate_limit_register}{(Optional) A numeric value.}

\item{rate_limit_register_per_second}{(Optional) A numeric value.}

\item{rate_limit_image}{(Optional) A numeric value.}

\item{rate_limit_image_per_second}{(Optional) A numeric value.}

\item{rate_limit_comment}{(Optional) A numeric value.}

\item{rate_limit_comment_per_second}{(Optional) A numeric value.}

\item{rate_limit_search}{(Optional) A numeric value.}

\item{rate_limit_search_per_second}{(Optional) A numeric value.}

\item{federation_enabled}{(Optional) A logical value.}

\item{federation_debug}{(Optional) A logical value.}

\item{captcha_enabled}{(Optional) A logical value.}

\item{captcha_difficulty}{(Optional) A character value.}

\item{allowed_instances}{(Optional) A character vector.}

\item{blocked_instances}{(Optional) A character vector.}

\item{taglines}{(Optional) A character vector.}

\item{registration_mode}{(Optional) One of "Closed", "RequireApplication", or "Open".}

\item{auth}{A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 2:
\preformatted{<list>
|-site_view: <list>
| |-site: <list>
| | |-id: A numeric value
| | |-name: A character value
| | |-sidebar: (Optional) A character value
| | |-published: A character value
| | |-updated: (Optional) A character value
| | |-icon: (Optional) A character value
| | |-banner: (Optional) A character value
| | |-description: (Optional) A character value
| | |-actor_id: A character value
| | |-last_refreshed_at: A character value
| | |-inbox_url: A character value
| | |-private_key: (Optional) A character value
| | |-public_key: A character value
| | `-instance_id: A numeric value
| |-local_site: <list>
| | |-id: A numeric value
| | |-site_id: A numeric value
| | |-site_setup: A logical value
| | |-enable_downvotes: A logical value
| | |-enable_nsfw: A logical value
| | |-community_creation_admin_only: A logical value
| | |-require_email_verification: A logical value
| | |-application_question: (Optional) A character value
| | |-private_instance: A logical value
| | |-default_theme: A character value
| | |-default_post_listing_type: One of "All", "Local", or "Subsc...
| | |-legal_information: (Optional) A character value
| | |-hide_modlog_mod_names: A logical value
| | |-application_email_admins: A logical value
| | |-slur_filter_regex: (Optional) A character value
| | |-actor_name_max_length: A numeric value
| | |-federation_enabled: A logical value
| | |-captcha_enabled: A logical value
| | |-captcha_difficulty: A character value
| | |-published: A character value
| | |-updated: (Optional) A character value
| | |-registration_mode: One of "Closed", "RequireApplica...
| | `-reports_email_admins: A logical value
| |-local_site_rate_limit: <list>
| | |-id: A numeric value
| | |-local_site_id: A numeric value
| | |-message: A numeric value
| | |-message_per_second: A numeric value
| | |-post: A numeric value
| | |-post_per_second: A numeric value
| | |-register: A numeric value
| | |-register_per_second: A numeric value
| | |-image: A numeric value
| | |-image_per_second: A numeric value
| | |-comment: A numeric value
| | |-comment_per_second: A numeric value
| | |-search: A numeric value
| | |-search_per_second: A numeric value
| | |-published: A character value
| | `-updated: (Optional) A character value
| `-counts: <list>
|   |-id: A numeric value
|   |-site_id: A numeric value
|   |-users: A numeric value
|   |-posts: A numeric value
|   |-comments: A numeric value
|   |-communities: A numeric value
|   |-users_active_day: A numeric value
|   |-users_active_week: A numeric value
|   |-users_active_month: A numeric value
|   `-users_active_half_year: A numeric value
`-taglines: <list>
  `-[Each element]: <list>
    |-id: A numeric value
    |-local_site_id: A numeric value
    |-content: A character value
    |-published: A character value
    `-updated: (Optional) A character value
}
}
\description{
\code{HTTP.POST /site}
}
