% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clm_MI_CR.R
\name{clm_MI_CR}
\alias{clm_MI_CR}
\title{Apply Copy-Reference(CR) Method to Update JAGS MCMC outputs under MAR for Cumulative Logistic Model}
\usage{
clm_MI_CR(object, treatment, start = NULL, end = NULL, thin = NULL,
  exclude_chains = NULL, subset = FALSE, ord_cov_dummy = TRUE,
  seed = NULL, mess = FALSE, ...)
}
\arguments{
\item{object}{an object of class remoid}

\item{treatment}{the variable name of treatment. Reference level of treatment should be coded as 0.}

\item{start}{first iteration to be used.}

\item{end}{last iteration to be used.}

\item{thin}{thinning to be applied.}

\item{exclude_chains}{optional vector of numbers, indexing MCMC chains to be excluded from the output.}

\item{subset}{subset of parameters (columns of the mcmc object) to be used.}

\item{ord_cov_dummy}{optional. specify whether ordinal variables should be treated as
categorical variables or continuous variables when they are
included as covariates in the sequential imputation models.
Default is \code{TRUE}, dummy variables will be created accordingly.}

\item{seed}{optional seed value.}

\item{mess}{logical, should messages be displayed?}

\item{...}{optional arguments pass from main function.}
}
\value{
A matrix of MCMC samples with all monitored parameters.A subset of
the MCMC sample can be selected using \code{start}, \code{end} and
\code{thin}.
}
\description{
Internal function to obtain Copy-Reference(CR) MCMC from an MAR object.
}
