% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_rga2h.R
\name{rga2h}
\alias{rga2h}
\title{reverse graphical approach for two hypotheses}
\usage{
rga2h(w, G, p, alpha)
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}

\item{p}{a vector of p-values}

\item{alpha}{a number of significance level}
}
\value{
a logical vector indicating whether the hypothesis is rejected: TRUE = rejected, FALSE = accepted
}
\description{
reverse graphical approach for two hypotheses
}
\examples{
w <- c(0.3,0.7)
G <- matrix(c(0,1,1,0),nrow=2,byrow=TRUE)
p <- c(0.032, 0.038)
alpha <- 0.05
rga2h(w=w,G=G,p=p, alpha=alpha)

}
\references{
Gou, J. (2020). Reverse graphical approaches for multiple test procedures. Technical Report.
}
\author{
Jiangtao Gou
}
