% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_conditionCheck.R
\name{conditionCheck}
\alias{conditionCheck}
\title{Condition check for strong FWER control in RGA}
\usage{
conditionCheck(w, G)
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}
}
\value{
a logical value indicating whether the RGA's conditions are satisfied or not for the strong FWER control
}
\description{
Check the sufficient condition in RGA for the strong FWER control.
}
\details{
The conditions verified here are sufficient conditions. If a logical value \code{TRUE} is returned, then the strong control of the FWER is guaranteed. The strong control of the FWER may still hold even if the output is \code{FALSE}.
}
\examples{
w <- c(0.1,0.2,0.3,0.4)
G <- matrix(c(0,0.3,0.3,0.4, 0.6,0,0.2,0.2, 0.5,0.2,0,0.3, 0.3,0.4,0.3,0),nrow=4,byrow=TRUE)
conditionCheck(w=w,G=G)
}
\author{
Jiangtao Gou
}
