% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_mRNAfeat.R
\name{refseq_mRNAfeat}
\alias{refseq_mRNAfeat}
\title{Get mRNA features}
\usage{
refseq_mRNAfeat(transcript , feat)
}
\arguments{
\item{transcript}{A character string of the transcript id.}

\item{feat}{A character string of the selected features. Allowed features: 'caption',
'moltype', 'sourcedb', 'updatedate', 'slen', 'organism', 'title'.}
}
\value{
A \code{tibble} of summarized results including columns:
\itemize{
\item caption, mRNA accession
\item moltype, type of molecule
\item sourcedb, database (GenBank)
\item updatedate, date of updated record
\item slen, molecule length (in bp)
\item organism
\item title, sequence description
}
}
\description{
\code{refseq_mRNAfeat()} Returns a number of features from a single/multiple mRNA accession(s).

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
# Get several molecular features from a set of mRNA accessions
transcript = c("XM_004487701", "XM_004488493", "XM_004501904")
feat = c("caption", "moltype", "sourcedb", "slen")
refseq_mRNAfeat(transcript ,feat)

}
\seealso{
\code{\link{refseq_fromGene}} to obtain the transcript or protein accession from a single GeneID accession.

\code{\link{refseq_RNA2protein}} to obtain the protein accessions encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
