\name{truncated_qqplot}
\alias{truncated_qqplot}
\title{Quantile-Quantile plot of truncated laboratory results}
\description{
Generates and plots a quantile-quantile plot (q-q plot) with a theoretical normal distribution on the x-axis and the corresponding empirical distribution on the y-axis. Returns intercept, slope, and estimated quantiles 0.025 and 0.975 (i.e., reference limits).
}
\usage{
truncated_qqplot(x.trunc, lognormal = NULL, perc.trunc = 2.5, n.min = 200,
  apply.rounding = TRUE, plot.it = TRUE,
  main = "Q-Q plot",
  xlab = "theoretical quantiles",
  ylab = "sample quantiles")
}
\arguments{
\item{x.trunc}{truncated numeric vector of positive numbers, usually generated by iboxplot()}
\item{lognormal}{Boolean indicating whether a lognormal distribution should be assumed (NULL means that the distribution type is defined automatically)}
\item{perc.trunc}{percentage of values that has been removed from each side by truncation}
\item{n.min}{minimal number of values in x.trunc for a robust estimate of reference limits}
\item{apply.rounding}{Boolean indicating whether the reference limits should be rounded}
\item{plot.it}{Boolean indicating whether a graphic should be created}
\item{main, xlab, ylab}{title and labels of the graphic}
}
\value{
\item{$result}{intercept and slope of the q-q plot, lower and upper truncation points}
\item{$lognormal}{Boolean indicating whether a lognormal distribution has been assumed}

}
\details{
Intercept and slope of the q-q plot represent the robust mean and standard deviation of x.trunc. They serve as parameters to estimate the reference limits being represented by the quantiles 0.025 and 0.975 of a presumably normal subset of x.
}
\references{
1. Hoffmann G et al. Simple estimation of reference intervals from routine laboratory data. J Lab Med 2016. \doi{10.1515/labmed-2015-0104}.
}
\examples{
set.seed(123)
x <- rlnorm(n = 250, meanlog = 3,  sdlog = 0.3)
x.trunc <- iboxplot(x, plot.it = FALSE)$trunc
truncated_qqplot(x.trunc)

x.f <- subset(livertests, livertests$Sex == "f")
x.trunc <- iboxplot(x.f$ALT, plot.it = FALSE)$trunc
truncated_qqplot(x.trunc, n.min = length(x.trunc), main = "ALT")
}
