% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{getRISimilarity}
\alias{getRISimilarity}
\title{Calculate similarity of two reference intervals}
\usage{
getRISimilarity(
  RIdata,
  RIcand,
  RIperc = c(0.025, 0.975),
  pointEst = c("fullDataEst", "medianBS"),
  UMprop = 0.9,
  Overlap = c("OverlapMargins", "OverlapPointEst"),
  printResults = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{RIdata}{specifying the RI of the local population: (1) (object) of class \code{RWDRI} or (2) (numeric) representation of reference limits}

\item{RIcand}{specifying the RI that needs to be verified: (1) (object) of class \code{RWDRI} or (2) (numeric) representation of reference limits}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default c(0.025, 0.975))}

\item{pointEst}{(character) specifying the point estimate determination: (1) using the full dataset ("fullDataEst"),
(2) calculating the median model from the bootstrap samples ("medianBS"), (2) works only if NBootstrap > 0}

\item{UMprop}{(numeric) specifying the confidence level for the uncertainty margins}

\item{Overlap}{(character) specifying the overlap criteria for the verification process. Options are:
(1) uncertainty margins overlap "OverlapMargins" and
(2) point estimates must be within the uncertainty margins "OverlapPointEst"}

\item{printResults}{(logical) specifying if the results are printed to the console}

\item{verbose}{(logical) specifying if additional warning messages are printed}

\item{...}{arguments to overwrite the default values of the Uncertainty Margin calculation}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{		(data.frame) containing the similarity of the two reference intervals
}\if{html}{\out{</div>}}
}
\description{
Calculate similarity of two reference intervals
}
\examples{
\dontrun{
	example <- list(Mu = 3.41, Sigma = 0.504, Shift = 1, Lambda = 0.06,
							  Method = "manual", roundingBase = NA)
	class(example) <- "RWDRI"
	test <- getRISimilarity(example, c(4, 55.5))
	getRISimilarity(c(4, 55.5), c(6, 58))
	getRISimilarity(c(4, 55.5), c(6, 58), UMprop = 0.95)
}
}
\author{
Matthias Beck \email{matthias.beck.mb1@roche.com}
}
