% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_checks.R
\name{refdb_check_seq_conflict}
\alias{refdb_check_seq_conflict}
\title{Check for conflicts in sequences}
\usage{
refdb_check_seq_conflict(x, na_omit = TRUE)
}
\arguments{
\item{x}{a reference database.}

\item{na_omit}{if \code{FALSE} conflicts involving
NA taxonomic names are also reported.}
}
\value{
A list of two-columns tibbles reporting duplicated
sequences with different taxonomy.
}
\description{
Check for conflicts in sequences
}
\examples{
lib <- read.csv(system.file("extdata", "ephem.csv", package = "refdb"))
lib <- refdb_set_fields(lib,
                        taxonomy = c(family = "family_name",
                            genus = "genus_name",
                            species = "species_name"),
                        sequence = "DNA_seq",
                        marker = "marker")
refdb_check_seq_conflict(lib)

}
