% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_pair.R
\name{cluster_pair}
\alias{cluster_pair}
\title{Generate all possible pairs using multiple processes}
\usage{
cluster_pair(cluster, x, y, deduplication = FALSE, name = "default")
}
\arguments{
\item{cluster}{a cluster object as created by \code{\link[parallel]{makeCluster}}
from \code{parallel} or from the \code{snow} package.}

\item{x}{first \code{data.frame}}

\item{y}{second \code{data.frame}. Ignored when \code{deduplication = TRUE}.}

\item{deduplication}{generate pairs from only \code{x}. Ignore \code{y}. This 
is usefull for deduplication of \code{x}.}

\item{name}{the name of the resulting object to create locally on the different
R processes.}
}
\value{
A object of type \code{cluster_pairs} which is a \code{list} containing the
cluster and the name of the pairs object on the cluster nodes. For the pairs
objects created on the nodes see the documentation of \code{\link{pair}}.
}
\description{
Generates all combinations of records from \code{x} and \code{y}.
}
\details{
Generating (all) pairs of the records of two data sets, is usually the first 
step when linking the two data sets. 

\code{x} is split into \code{length{cluster}} parts which are distributed
over the worker nodes. \code{y} is copied to each of the nodes. On the nodes
then \code{\link{pair}} is called. The pairs are stored in the global
object \code{reclin_env} on the nodes in the variable \code{name}. The pairs
can then be further processes using functions such as
\code{\link{compare_pairs}}, and \code{\link{tabulate_patterns}}. The function
\code{\link{cluster_collect}} collects the pairs from each of the nodes.
}
\examples{
library(parallel)
data("linkexample1", "linkexample2")
cl <- makeCluster(2)
\dontshow{clusterEvalQ(cl, data.table::setDTthreads(1))}
pairs <- cluster_pair(cl, linkexample1, linkexample2)
stopCluster(cl)

}
\seealso{
\code{\link{cluster_pair_blocking}} and \code{\link{cluster_pair_minsim}} are
other methods to generate pairs.
}
