% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ciPetersen}
\alias{ciPetersen}
\title{Confidence Intervals for the Petersen Estimator}
\usage{
ciPetersen(
  n1,
  n2,
  m2,
  conf = 0.95,
  method = "both",
  bootreps = 10000,
  useChapvar = FALSE
)
}
\arguments{
\item{n1}{Number of individuals captured and marked in the first sample}

\item{n2}{Number of individuals captured in the second sample}

\item{m2}{Number of marked individuals recaptured in the second sample}

\item{conf}{The confidence level of the desired intervals.  Defaults to 0.95.}

\item{method}{Which method of confidence interval to return.  Allowed values
are \code{"norm"}, \code{"boot"}, or \code{"both"}.  Defaults to
\code{"both"}.}

\item{bootreps}{Number of bootstrap replicates to use.  Defaults to 10000.}

\item{useChapvar}{Whether to use the Chapman estimator variance instead of
the Petersen estimator variance for the normal-distribution interval.
Defaults to \code{FALSE}.}
}
\value{
A list with the abundance estimate and confidence interval bounds for
  the normal-distribution and/or bootstrap confidence intervals.
}
\description{
Calculates approximate confidence intervals(s) for the Petersen
  estimator, using bootstrapping, the Normal approximation, or both.

  The bootstrap interval is created by resampling the data in the second
  sampling event, with replacement; that is, drawing bootstrap values of m2
  from a binomial distribution with probability parameter m2/n2.  This
  technique has been shown to better approximate the distribution of the
  abundance estimator.  Resulting CI endpoints both have larger values than
  those calculated from a normal distribution, but this better captures the
  positive skew of the estimator.  Coverage has been investigated by means of
  simulation under numerous scenarios and has consistently outperformed the
  normal interval.  The user is welcomed to investigate the coverage under
  relevant scenarios.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
ciPetersen(n1=100, n2=100, m2=20)
}
\seealso{
\link{NPetersen}, \link{vPetersen}, \link{sePetersen},
  \link{rPetersen}, \link{pPetersen}, \link{powPetersen}
}
\author{
Matt Tyers
}
