% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{NBailey}
\alias{NBailey}
\title{Bailey Estimator}
\usage{
NBailey(n1, n2, m2)
}
\arguments{
\item{n1}{Number of individuals captured and marked in the first sample. This
may be a single number or vector of values.}

\item{n2}{Number of individuals captured in the second sample.  This may be a
single number or vector of values.}

\item{m2}{Number of marked individuals recaptured in the second sample.  This
may be a single number or vector of values.}
}
\value{
The value of the Bailey estimator, calculated as n1*(n2+1)/(m2+1)
}
\description{
Calculates the value of the Bailey estimator for abundance in a
  mark-recapture experiment, with given values of sample sizes and number of
  recaptures.  The Bailey estimator assumes a binomial probability model in
  the second sampling event (i.e. sampling with replacement), rather than the
  hypergeometric model assumed by the Petersen and Chapman estimators.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
NBailey(n1=100, n2=100, m2=20)
}
\references{
Bailey, N.T.J. (1951). On estimating the size of mobile populations from capture-recapture data.  \emph{Biometrika} \strong{38}, 293-306.

Bailey, N.T.J. (1952). Improvements in the interpretation of recapture data.  \emph{J. Animal Ecol.} \strong{21}, 120-7.
}
\seealso{
\link{NPetersen}, \link{NChapman}, \link{vBailey}, \link{seBailey}, \link{rBailey}, \link{pBailey},
  \link{powBailey}, \link{ciBailey}
}
\author{
Matt Tyers
}
