% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hADCPLoads.R
\name{hADCPLoads}
\alias{hADCPLoads}
\title{Compute sediment load per guideline using acoustic backscatter from processed hADCP data}
\usage{
hADCPLoads(InputData)
}
\arguments{
\item{InputData}{List generated by import_data.R}
}
\value{
list with data frames of estimated concentration and flux along with data used in regression and surrogate timeseries
}
\description{
Computes sediment load per guideline from user data in list "InputData" generated by function import_data()
}
\examples{
\donttest{
# loads example data in package folder extdata
InputData <- import_data()
# import_data(path) can be used to import user data
Output <- hADCPLoads(InputData)
}
}
\references{
Livsey, D.N. (in review). National Industry Guidelines for hydrometric monitoring–Part 12: Application of acoustic Doppler velocity meters to measure suspended-sediment load. Bureau of Meteorology. Melbourne, Australia.
}
\seealso{
\code{\link{import_data}} Import data from files in user-specified folder
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
