% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_regression.R
\name{bootstrap_regression}
\alias{bootstrap_regression}
\title{Regression parameters estimated using bootstrap resampling}
\usage{
bootstrap_regression(Calibration, fit_eq, fit_glm = FALSE)
}
\arguments{
\item{Calibration}{data frame with surrogate(s) followed by analyte in last column}

\item{fit_eq}{equation used to fit y(x), string (e.g, "y ~ x + x2", "y ~ x", "log10(y)~x')}

\item{fit_glm}{logical to use Generalized Linear Models for models with factor (i.e., categorical) predictors}
}
\value{
list with bootstrap regression parameters and list output from stats::lm()
}
\description{
Computes uncertainty in regression parameters of y(x) after Rustomji and Wilkinson (2008)
}
\section{Warning}{

User should inspect regression residuals and relevant statistics to ensure model form is reasonable, suggested reading: regression diagnostics in Statistical Methods in Water Resources (https://doi.org/10.3133/tm4a3).

One can call plot(fit) to view various regression diagnostic plots
}

\section{Note}{

Bias Correction Factor (BCF) is only relevant when analyte is transformed to log units, see https://doi.org/10.3133/tm4a3
to convert a model that used log(analyte) back to linear units use: analyte = 10^(f(surrogates)) x BCF
}

\examples{
\donttest{
# linear model
x <- 1:10
y <- 0.5*x + 10
boot <- bootstrap_regression(data.frame(x,y),"y~x")
# polynomial model, call to I() needed for squaring x in equation string
x <- 1:10
y <- x + x^2
boot <- bootstrap_regression(data.frame(x,y),"y ~ x+I(x^2)")
# power law model
# BCF returned since y is transformed to log units
x <- 1:10
y <- x^0.3
boot <- bootstrap_regression(data.frame(x,y),"log10(y)~log10(x)")
# multivariate model
a <- 1:10
b <- a*2
c <- a^2*b^3
boot <- bootstrap_regression(data.frame(a,b,c),"log10(c)~log10(a)+log10(b)")
}
}
\references{
Rustomji, P., & Wilkinson, S. N. (2008). Applying bootstrap resampling to quantify uncertainty in fluvial suspended sediment loads estimated using rating curves. Water resources research, 44(9).https://doi.org/10.1029/2007WR006088

Helsel, D.R., Hirsch, R.M., Ryberg, K.R., Archfield, S.A., and Gilroy, E.J., 2020, #' Statistical methods in water resources: U.S. Geological Survey Techniques and Methods, book 4, chap. A3, 458 p. https://doi.org/10.3133/tm4a3
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
