% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-0-0sens.R
\name{sens}
\alias{sens}
\title{Sensitivity Analysis for rdlearn Objects}
\usage{
sens(object, M = NULL, cost = NULL, trace = TRUE)
}
\arguments{
\item{object}{An object of class \code{rdlearn} returned by the
\code{\link{rdlearn}} function.}

\item{M}{A numeric value or vector specifying the multiplicative smoothness
factor(s) for sensitivity analysis.}

\item{cost}{A numeric value or vector specifying the cost of treatment for
calculating regret.}

\item{trace}{A logical value that controls whether to display the progress of
cross-fitting and regret calculation. If set to TRUE, the progress will be
printed. The default value is TRUE.}
}
\value{
An updated \code{rdlearn} object with the new cutoffs based on the
  provided values of M and cost.
}
\description{
This function performs sensitivity analysis for the \code{rdlearn} object
under different smoothness multiplier (M) and the cost of treatment (cost).
}
\examples{
# Simulation Data B from Appendix D of Zhang et al. (2022)
set.seed(1)
n <- 300
X <- runif(n, -1000, -1)
G <- 2 * as.numeric(
I(0.01 * X + 5 + rnorm(n, sd = 10) > 0)
) +
as.numeric(
I(0.01 * X + 5 + rnorm(n, sd = 10) <= 0)
)
c1 <- -850
c0 <- -571
C <- ifelse(G == 1, c1, c0)
D <- as.numeric(X >= C)
coef0 <- c(-1.992230e+00, -1.004582e-02, -1.203897e-05, -4.587072e-09)
coef1 <- c(9.584361e-01, 5.308251e-04, 1.103375e-06, 1.146033e-09)
Px <- poly(X, degree = 3, raw = TRUE)
# Px = poly(X-735.4334-c1,degree=3,raw=TRUE) for Simulation A
Px <- cbind(rep(1, nrow(Px)), Px)
EY0 <- Px \%*\% coef0
EY1 <- Px \%*\% coef1
d <- 0.2 + exp(0.01 * X) * (1 - G) + 0.3 * (1 - D)
Y <- EY0 * (1 - D) + EY1 * D - d * as.numeric(I(G == 1)) + rnorm(n, sd = 0.3)

simdata_B_demo <- data.frame(Y,X,C)

# Learn new treatment assignment cutoffs
rdlearn_result <- rdlearn(
  y = "Y", x = "X", c = "C", data = simdata_B_demo,
  fold = 2, M = 0, cost = 0
)

# Summarise the learned policies
summary(rdlearn_result)

# Visualize the learned policies
plot(rdlearn_result, opt = "dif")
# The learned cutoff for Group 1 is the same as the baseline cutoff, because
# the baseline cutoff is set to equal to oracle cutoff in this simulation.

# Implement sensitivity analysis
sens_result <- sens(rdlearn_result, M = 1, cost = 0)
plot(sens_result, opt = "dif")
}
