% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_np.R
\name{rdd_reg_np}
\alias{rdd_reg_np}
\title{Parametric polynomial estimator of the regression discontinuity}
\usage{
rdd_reg_np(
  rdd_object,
  covariates = NULL,
  bw = rdd_bw_ik(rdd_object),
  slope = c("separate", "same"),
  inference = c("np", "lm"),
  covar.opt = list(slope = c("same", "separate"), bw = NULL)
)
}
\arguments{
\item{rdd_object}{Object of class rdd_data created by \code{\link{rdd_data}}}

\item{covariates}{TODO}

\item{bw}{A bandwidth to specify the subset on which the parametric regression is estimated}

\item{slope}{Whether slopes should be different on left or right (separate), or the same.}

\item{inference}{Type of inference to conduct: non-parametric one (\code{np}) or standard (\code{lm}). See details.}

\item{covar.opt}{Options for the inclusion of covariates. Way to include covariates, either in the main regression (\code{include}) or as regressors of y in a first step (\code{residual}).}
}
\value{
An object of class rdd_reg_np and class lm, with specific print and plot methods
}
\description{
Compute a parametric polynomial regression of the ATE, 
possibly on the range specified by bandwidth
}
\examples{
## Step 0: prepare data
data(house)
house_rdd <- rdd_data(y=house$y, x=house$x, cutpoint=0)
## Step 2: regression
# Simple polynomial of order 1:
reg_nonpara <- rdd_reg_np(rdd_object=house_rdd)
print(reg_nonpara)
plot(reg_nonpara)
}
\references{
TODO
}
\seealso{
\code{\link{rdd_bw_ik}} Bandwidth selection using the plug-in bandwidth of Imbens and Kalyanaraman (2012)
}
