% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseMean.r
\name{groupwiseMean}
\alias{groupwiseMean}
\title{Groupwise means and confidence intervals}
\usage{
groupwiseMean(
  formula = NULL,
  data = NULL,
  var = NULL,
  group = NULL,
  trim = 0,
  na.rm = FALSE,
  conf = 0.95,
  R = 5000,
  boot = FALSE,
  traditional = TRUE,
  normal = FALSE,
  basic = FALSE,
  percentile = FALSE,
  bca = FALSE,
  digits = 3,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variables. e.g. y ~ x1 + x2.}

\item{data}{The data frame to use.}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{trim}{The proportion of observations trimmed from each end of the
values before the mean is calculated. (As in \code{mean()})}

\item{na.rm}{If \code{TRUE}, \code{NA} values are removed during 
calculations. (As in \code{mean()})}

\item{conf}{The confidence interval to use.}

\item{R}{The number of bootstrap replicates to use for bootstrapped
statistics.}

\item{boot}{If \code{TRUE}, includes the mean of the bootstrapped means.
This can be used as an estimate of the mean for
the group.}

\item{traditional}{If \code{TRUE}, includes the traditional confidence
intervals for the group means, using the t-distribution.
If \code{trim} is not 0, 
the traditional confidence interval
will produce \code{NA}.
Likewise, if there are \code{NA} values that are not
removed, the traditional confidence interval
will produce \code{NA}.}

\item{normal}{If \code{TRUE}, includes the normal confidence
intervals for the group means by bootstrap.
See \code{boot.ci}.}

\item{basic}{If \code{TRUE}, includes the basic confidence
intervals for the group means by bootstrap.
See \code{boot.ci}.}

\item{percentile}{If \code{TRUE}, includes the percentile confidence
intervals for the group means by bootstrap.
See \code{boot.ci}.}

\item{bca}{If \code{TRUE}, includes the BCa confidence
intervals for the group means by bootstrap.
See \code{boot.ci}.}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments passed to the \code{boot} function.}
}
\value{
A data frame of requested statistics by group.
}
\description{
Calculates means and confidence intervals for
             groups.
}
\details{
The input should include either \code{formula} and \code{data};
             or \code{data}, \code{var}, and \code{group}. (See examples).
         
         Results for ungrouped (one-sample) data can be obtained by either
         setting the right side of the formula to 1, e.g.  y ~ 1, or by
         setting \code{group=NULL} when using \code{var}.
}
\note{
The parsing of the formula is simplistic. The first variable on the
         left side is used as the measurement variable.  The variables on the
         right side are used for the grouping variables.
       
         In general, it is advisable to handle \code{NA} values before
         using this function.
         With some options, the function may not handle missing values well,
         or in the manner desired by the user.
         In particular, if \code{bca=TRUE} and there are \code{NA} values,
         the function may fail.
         
         For a traditional method to calculate confidence intervals 
         on trimmed means,
         see Rand Wilcox, Introduction to Robust Estimation and
         Hypothesis Testing.
}
\examples{
### Example with formula notation
data(Catbus)
groupwiseMean(Steps ~ Teacher + Gender,
              data        = Catbus,
              traditional = FALSE,
              percentile  = TRUE)

### Example with variable notation
data(Catbus)
groupwiseMean(data        = Catbus,
              var         = "Steps",
              group       = c("Teacher", "Gender"),
              traditional = FALSE,
              percentile  = TRUE)
                                     
}
\references{
\url{https://rcompanion.org/handbook/C_03.html}
}
\seealso{
\code{\link{groupwiseMedian}}, 
         \code{\link{groupwiseHuber}},
         \code{\link{groupwiseGeometric}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{confidence interval}
\concept{mean}
\concept{summary statistics}
