% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_species_by.R
\name{rcatfish_species_by}
\alias{rcatfish_species_by}
\title{Find number of available fish names, number of valid species, and number of descriptions in the last 10 years by family or subfamily}
\usage{
rcatfish_species_by(query, verbose = TRUE)
}
\arguments{
\item{query}{A character vector of taxa to search for. For users wishing to obtain the information for all fishes please query "Totals".}

\item{verbose}{Logical. Should query progress be messaged to the screen? Default is TRUE.}
}
\value{
A list with each element containing a data frame for each query. List elements are named by the queried taxa.
The list contains information on the number of genera and species available, valid, and described in the last 10 years. An itemized list describing the contents in the columns of the data frame(s) returned is described below.
#' \itemize{
\item Class - Character. Taxonomic class.
\item Order - Character. Taxonomic order.
\item Family - Character. Taxonomic family
\item Subfamily - Character. Taxonomic subfamily.
\item Available.Genera - Integer. Number of available genera for the taxonomic rank.
\item Valid.Genera - Integer. Number of valid genera for the taxonomic rank.
\item Genera.Last.Ten.Years - Integer. Number of genera described over the past ten years for the taxonomic rank.
\item Available.Species - Integer. Number of available species for the taxonomic rank.
\item Valid.Species - Integer. Number of valid species for the taxonomic rank.
\item Species.Last.Ten.Years - Integer. Number of species described over the past ten years for the taxonomic rank.
}
}
\description{
This function retrieves and parses data on the number of genera and species per family from the
Eschmeyer's Catalog of Fishes. It returns a table containing the number of genera and species that are available, valid,
and described in the last 10 years in its columns. Each row represents either a class, order, family, or subfamily, so
some columns for higher taxonomic groups may have NA for lower taxonomic groups (e.g. if you Search for Cypriniformes, the row
containing Cypriniformes will have NA for family and subfamily as it is above those taxonomic levels).

Given the function reads in the page containing the table, for speed, it is highly recommended that if a user wishes to obtain
information on numerous orders, families, or subfamilies that they pass them in as a single query. To do this, see the last example.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
\donttest{
#Search for the number of described Cypriniformes
MySearch <- rcatfish_species_by(query = "Cypriniformes") 
#Obtain the total number of genera and species available, valid, and described in the last 10 years
CofF_totals <- rcatfish_species_by(query = "Totals")
#Search for more than one family
MySearch <- rcatfish_species_by(query = c("Cichlidae","Embiotocidae"))
}
\dontshow{\}) # examplesIf}
}
\references{
Fricke, R., Eschmeyer, W.N. & Fong J.D. (Year Accessed). Eschmeyer’s Catalog of Fishes: Species by family/subfamily in the Catalog of Fishes. https://researcharchive.calacademy.org/research/ichthyology/catalog/SpeciesByFamily.asp.
}
\author{
Samuel R. Borstein
}
