% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rem_isolated_black_pixels.R
\name{rem_isolated_black_pixels}
\alias{rem_isolated_black_pixels}
\title{Remove isolated black pixels}
\usage{
rem_isolated_black_pixels(bin)
}
\arguments{
\item{bin}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with a single layer.}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer.
}
\description{
Replace single black pixels (\code{FALSE}) that are fully surrounded by white
pixels (\code{TRUE}) with white. Uses 8-connectivity.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

path <- system.file("external/example.txt", package = "rcaiman")
sky <- read_sky_cie(gsub(".txt", "", path), caim$Blue, z, a)
plot(sky$rr_raster)
sky <- sky$rr_raster * sky$model$rr$zenith_dn

bin <- binarize_with_thr(r / sky, 0.9)
plot(bin)
bin2 <- rem_isolated_black_pixels(bin)
plot(bin2)
}
}
