% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_diameter.R
\name{calc_diameter}
\alias{calc_diameter}
\title{Calculate diameter}
\usage{
calc_diameter(lens_coef, radius, angle)
}
\arguments{
\item{lens_coef}{numeric vector. Polynomial coefficients of the lens
projection function. See \code{\link[=lens]{lens()}}.}

\item{radius}{numeric vector. Distance in pixels from the zenith.}

\item{angle}{numeric vector. Zenith angle in degrees.}
}
\value{
Numeric vector of length one. Estimated diameter in pixels, rounded
to the nearest even integer (see \code{\link[=zenith_image]{zenith_image()}} for details).
}
\description{
Calculate the diameter in pixels of a 180 deg fisheye image.
}
\details{
This function is useful when the recording device has a field of view smaller
than 180 deg. Given a lens projection function and data points consisting of
radii (pixels) and their corresponding zenith angles (\eqn{\theta}), it
returns the horizon radius (i.e., the radius for \eqn{\theta} equal to 90 deg).

When working with non-circular hemispherical photography, this function
helps determine the diameter that a circular image would have if the
equipment recorded the whole hemisphere, required to build the
correct zenith image to use as input for \code{\link[=expand_noncircular]{expand_noncircular()}}.

The required data (radius–angle pairs) can be obtained following the
instructions in the
\href{https://www.schleppi.ch/patrick/hemisfer/help/en/lens.htm}{user manual of Hemisfer software}.
A slightly simpler alternative is:
\enumerate{
\item Find a vertical wall and a leveled floor, both well-constructed.
\item Draw a triangle of \eqn{5 \times 4 \times 3} meters on the floor, with the
4-meter side along the wall.
\item Place the camera over the vertex 3 meters away from the wall, at a chosen
height (e.g., 1.3 m).
\item Make a mark on the wall at the chosen height over the wall-vertex nearest
to the camera vertex. Make four more marks at 1 m intervals along a
horizontal line. This creates marks for 0, 18, 34, 45, and 54 deg
\eqn{\theta}.
\item Before taking the photograph, align the zenith coordinates with the 0 deg
\eqn{\theta} mark and ensure the optical axis is level.
}

The \href{https://imagej.net/ij/docs/guide/146-19.html#toc-Subsection-19.2}{line selection tool}
of \href{https://imagej.net/ij/}{ImageJ} can be used to measure the distance in
pixels between points on the image. Draw a line and use the menu
Analyze > Measure to obtain its length.

For obtaining the projection of a new lens, see \code{\link[=calibrate_lens]{calibrate_lens()}}.
}
\examples{
# Nikon D50 and Fisheye Nikkor 10.5mm lens
calc_diameter(lens("Nikkor_10.5mm"), 1202, 54)
}
