% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_bddk.R
\name{fetch_bddk}
\alias{fetch_bddk}
\title{Fetch multiple period table from BDDK website}
\usage{
fetch_bddk(
  start_year,
  start_month,
  end_year,
  end_month,
  table_no,
  grup_kod = 10001,
  currency = "TL",
  lang = "en",
  delay = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{start_year, end_year}{Starting/ending year (YYYY).}

\item{start_month, end_month}{Starting/ending month (1-12).}

\item{table_no}{Table number to fetch (1-17). No default.
Use \code{\link{list_tables}} with \code{source = "bddk"} to see available options.}

\item{grup_kod}{Group code (10001-10016). Default 10001.
Use \code{\link{list_groups}} with \code{source = "bddk"} to see available options.}

\item{currency}{Currency code ("TL" or "USD"). Default "TL".}

\item{lang}{Language ("en" or "tr"). Default "en".}

\item{delay}{Delay between requests in seconds. Default 0.5.}

\item{verbose}{Print progress messages. Default TRUE.}
}
\value{
Combined data frame with "fetch_info" attribute.
}
\description{
Fetches BDDK data for a range of months by calling fetch_bddk1 iteratively.
}
\examples{
\donttest{
  # Fetch multiple months
  my_dat <- fetch_bddk(2024, 1, 2024, 3, table_no = 15)
}

}
\seealso{
\code{\link[=fetch_finturk]{fetch_finturk()}} for quarterly province-level data.
}
