% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_plot.R
\name{residual_plot}
\alias{residual_plot}
\title{Function to generate conditional regression equation plots (i.e., simple effects) with \code{\link{rblimp}} and SIMPLE command}
\usage{
residual_plot(
  model,
  variable,
  nsigma = 1,
  point_col = "black",
  horz_line = "black",
  col1 = "#0571b0",
  col2 = "#ca0020",
  linewidth = 1.1,
  ...
)
}
\arguments{
\item{model}{an \code{\link{blimp_obj}}. The object must have a SIMPLE command output saved.}

\item{variable}{the name of the outcome for which to create a plot}

\item{nsigma}{the number of standard deviations to produce credible bounds}

\item{point_col}{the color of the points in the plot}

\item{horz_line}{the color of the horiztonal zero line}

\item{col1}{the color of the loess mean line}

\item{col2}{the color of the loess credible bound lines}

\item{linewidth}{the linewidth value for the loess lines and its bounds.}

\item{...}{arguments passed to \code{\link{loess}} call used to loess lines.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} plot
}
\description{
Generates a conditional effect plots based on the posterior summaries from the output of \code{\link{rblimp}}.
}
\details{
All colors are passed into \code{ggplot2}. See \code{\link[ggplot2:aes_colour_fill_alpha]{ggplot2::aes_colour_fill_alpha}} for details on changing colors.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x ~ normal(0, 1)',
        'm ~ normal(0, 1)',
        'y ~ normal(10 + 0.5*x + m + 0.2*x*m, 1)'
    ),
    n = 100,
    seed = 981273
)

# Run Rblimp
m1 <- rblimp(
    'y ~ x m',
    mydata,
    nimps = 10,
    seed = 10972,
    burn = 1000,
    iter = 1000
)

# Generate Plot
residual_plot(m1, 'y') + ggplot2::theme_minimal()
\dontshow{\}) # examplesIf}
}
