% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jn_plot.R
\name{jn_plot}
\alias{jn_plot}
\title{Function to generate a Johnson-Neyman Plot of Conditional Slope with \code{\link{rblimp}}}
\usage{
jn_plot(formula, model, ci = 0.95, ...)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} to specify simple effect to plot.
The formula must have the following form: \code{outcome ~ focal | moderator}. See Details below for nominal moderators.}

\item{model}{an \code{\link{blimp_obj}}.}

\item{ci}{a value between 0 and 1 specifying the credible interval size}

\item{...}{passed bounds search algorithm. See \code{\link{jn_plot_func}} for details.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} plot. The bounding values are saved in the attribute 'bounds'.
}
\description{
Generates a Johnson-Neyman Plot based on the posterior summaries from the output of \code{\link{rblimp}}.
}
\details{
To change colors use ggplot2's scale system. Both fill and color are used. See
\code{\link[ggplot2:aes_colour_fill_alpha]{ggplot2::aes_colour_fill_alpha}} for more information about setting a manual set of colors.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x ~ normal(0, 1)',
        'm ~ normal(0, 1)',
        'y ~ normal(10 + 0.5*x + m + 0.2*x*m, 1)'
    ),
    n = 100,
    seed = 981273
)

# Run Rblimp
m1 <- rblimp(
    'y ~ x m x*m',
    mydata,
    center = ~ m,
    simple = 'x | m',
    seed = 10972,
    burn = 1000,
    iter = 1000
)

# Generate Plot
jn_plot(y ~ x | m, m1)

# Generate Plot with different colors
(
    jn_plot(y ~ x | m, m1)
    + ggplot2::scale_fill_manual(
        values = c(`FALSE` = '#ca0020', `TRUE` = '#0571b0')
    )
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=jn_plot_func]{jn_plot_func()}}
}
