% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_rna_edit}
\alias{rba_uniprot_rna_edit}
\title{Retrieve Epitope by Accession}
\usage{
rba_uniprot_rna_edit(accession, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing the UniProt RNA-editing features details for the
  given accession.
}
\description{
Use this function to retrieve
  \href{https://www.uniprot.org/help/rna_editing}{RNA-editing
  events} (conversion, insertion, deletion of nucleotides) annotations
  linked to a UniProt entry.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/rna-edit/\{accession\}"
}

\examples{
\donttest{
  rba_uniprot_rna_edit(accession = "Q16851")
}

}
\seealso{
Other "UniProt - Epitopes": 
\code{\link{rba_uniprot_epitope}()},
\code{\link{rba_uniprot_epitope_search}()}
}
\concept{"UniProt - Epitopes"}
