% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_tffm_search}
\alias{rba_jaspar_tffm_search}
\title{Search TF flexible models (TFFMs) available in JASPAR}
\usage{
rba_jaspar_tffm_search(
  term = NULL,
  release = 2024,
  tax_group = NULL,
  search = NULL,
  order = NULL,
  page_size = 1000,
  page = 1,
  ...
)
}
\arguments{
\item{term}{Character: A search term.}

\item{release}{Numeric: (default = 2024) Which JASPAR database release
to use? Available options are: 2024, 2022, 2020, 2018, 2016, and 2014.}

\item{tax_group}{Character: Taxonomic group. Use
\code{\link{rba_jaspar_taxons}} to get a list of supported Taxonomic
groups.}

\item{search}{Character: A search term.}

\item{order}{Character: A character string or a vector of character strings
of field names that will be used to order the results.
\cr Providing multiple field names is supported. You can also use prefix
"-" before a field name to indicate reverse ordering.}

\item{page_size}{Numeric: (default = 1000) This resource returns paginated
results. What is the maximum numbers of results that you want to retrieve
per a page? Accepted values are between 1 and 1000.}

\item{page}{Numeric: Which page of the results to retrieve? The accepted
values depend on the page size and number of results.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains a data frame with information of query hits'
  TFFMs.
}
\description{
You can use this function to list the JASPAR TF flexible models (TFFMs)
  that match your search query, or run the function without any
  arguments to return a list of every matrix profile available in the
  latest release.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
  \cr The results are paginated. You can control the page's size number
  with the function's arguments. Also, you can use \code{\link{rba_pages}}
  to automatically iterate over multiple pages.
}
\section{Corresponding API Resources}{

 "GET https://jaspar.elixir.no/api/v1/api/v1/tffm/"
}

\examples{
\donttest{
rba_jaspar_tffm_search(term = "FOX")
rba_jaspar_tffm_search(tax_group = "insects")
rba_jaspar_tffm_search(page_size = 100)
}

}
\references{
\itemize{
  \item Rauluseviciute I, Riudavets-Puig R, Blanc-Mathieu R,
  Castro-Mondragon JA, Ferenc K, Kumar V, Lemma RB, Lucas J, Chèneby J,
  Baranasic D, Khan A, Fornes O, Gundersen S, Johansen M, Hovig E, Lenhard
  B, Sandelin A, Wasserman WW, Parcy F, Mathelier A JASPAR 2024:
  20th anniversary of the open-access database of transcription factor
  binding profiles Nucleic Acids Res. in_press; doi: 10.1093/nar/gkad1059
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR data
  from any programming language. Bioinformatics, 2017,
  doi: 10.1093/bioinformatics/btx804
  \item
  \href{https://jaspar.elixir.no/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.elixir.no/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
