% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-cotahist.R
\name{cotahist_get}
\alias{cotahist_get}
\title{Access COTAHIST datasets}
\usage{
cotahist_get(type = c("yearly", "monthly", "daily"))
}
\arguments{
\item{type}{A string specifying the dataset to be used:
\code{"daily"}, \code{"monthly"}, or \code{"yearly"}.}
}
\value{
An \code{arrow_dplyr_query} or \code{ArrowObject}, representing a lazily evaluated query. The underlying data is not
collected until explicitly requested, allowing efficient manipulation of large datasets without immediate
memory usage.
To trigger evaluation and return the results as an R \code{tibble}, use \code{collect()}.
}
\description{
The COTAHIST files are available with daily, monthly, and yearly data.
Therefore, the datasets correspond to these periods (\code{daily}, \code{monthly}, \code{yearly}).
See \code{\link{download_marketdata}} and \code{\link{read_marketdata}} for
instructions on how to download the files and create the datasets.
}
\details{
The COTAHIST files contain historical quotation data (\emph{Cotações Históricas})
for stocks, stock options, stock forward contracts, ETFs, ETF options,
BDRs, UNITs, REITs (FIIs - \emph{Fundos Imobiliários}), FIAGROs (\emph{Fundos da Agroindústria}),
and FIDCs (\emph{Fundos de Direitos Creditórios}). These files from B3 hold
the oldest available information. The earliest annual file available dates back to 1986.
However, it is not recommended to use data prior to 1995 due to the monetary
stabilization process in 1994 (Plano Real).

Note that the prices in the files are not adjusted for corporate actions.
As a result, only ETF series can be used without issues.

Before using the dataset, it is necessary to download the files
using the \code{\link{download_marketdata}} function and create the datasets
with the \code{\link{read_marketdata}} function.
}
\examples{
\dontrun{
# get all data to the year of 2001
meta <- download_marketdata("b3-cotahist-yearly", year = 2001)
read_marketdata(meta)
ds_yearly <- cotahist_get()

# Earliest available annual file: 1986
# Recommended starting point: 1995 (after Plano Real)
}
\dontrun{
# To obtain data from January 2, 2014, the earliest available date:
meta <- download_marketdata("b3-cotahist-daily", refdate = as.Date("2014-01-02"))
read_marketdata(meta)
ds_daily <- cotahist_get("daily")
}
\dontrun{
# Once you download more dates, the data downloaded before remains stored and you can filter
# any date you want.
meta <- download_marketdata("b3-cotahist-daily", refdate = as.Date("2014-01-03"))
read_marketdata(meta)
df_daily <- cotahist_get("daily") |>
  filter(refdate == "2014-01-03") |>
  collect()
}

}
