% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class102-epoched_rawvoltage.R
\name{RAVESubjectEpochRawVoltageRepository}
\alias{RAVESubjectEpochRawVoltageRepository}
\title{'RAVE' class for epoch repository - raw voltage}
\description{
The repository inherits \code{link{RAVESubjectEpochRepository}}, with epoch
trials, and is intended for loading raw (without any processing or reference)
voltage signals.
Use \code{\link{prepare_subject_raw_voltage_with_epochs}} to create an
instance.
}
\section{Super classes}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{ravecore::RAVESubjectRepository} -> \code{\link[ravecore:RAVESubjectEpochRepository]{ravecore::RAVESubjectEpochRepository}} -> \code{RAVESubjectEpochRawVoltageRepository}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{digest_key}}{a list of repository data used to generate
repository signature}

\item{\code{raw_voltage}}{a named map of raw voltage data, mounted by
\code{mount_data}, alias of \code{get_container}}

\item{\code{reference_table}}{reference table, all channels will be marked as no reference}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubjectEpochRawVoltageRepository-@marshal}{\code{RAVESubjectEpochRawVoltageRepository$@marshal()}}
\item \href{#method-RAVESubjectEpochRawVoltageRepository-@unmarshal}{\code{RAVESubjectEpochRawVoltageRepository$@unmarshal()}}
\item \href{#method-RAVESubjectEpochRawVoltageRepository-new}{\code{RAVESubjectEpochRawVoltageRepository$new()}}
\item \href{#method-RAVESubjectEpochRawVoltageRepository-mount_data}{\code{RAVESubjectEpochRawVoltageRepository$mount_data()}}
\item \href{#method-RAVESubjectEpochRawVoltageRepository-clone}{\code{RAVESubjectEpochRawVoltageRepository$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRepository" data-id="@get_container"><a href='../../ravecore/html/RAVESubjectRepository.html#method-RAVESubjectRepository-@get_container'><code>ravecore::RAVESubjectRepository$@get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="export_matlab"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-export_matlab'><code>ravecore::RAVESubjectEpochRepository$export_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="get_container"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-get_container'><code>ravecore::RAVESubjectEpochRepository$get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="set_epoch"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-set_epoch'><code>ravecore::RAVESubjectEpochRepository$set_epoch()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochRawVoltageRepository-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochRawVoltageRepository-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochRawVoltageRepository$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochRawVoltageRepository-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochRawVoltageRepository-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochRawVoltageRepository$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochRawVoltageRepository-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochRawVoltageRepository-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochRawVoltageRepository$new(
  subject,
  electrodes = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE,
  lazy_load = FALSE,
  reference_name = "noref",
  .class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject}

\item{\code{electrodes}}{string or integers indicating electrodes to load}

\item{\code{epoch_name}}{name of the epoch trial table}

\item{\code{time_windows}}{numeric vector with even lengths, the time start
and end of the trials, for example, \code{c(-1, 2)} means load
1 second before the trial onset and 2 seconds after trial onset}

\item{\code{stitch_events}}{events where the \code{time_windows} is based;
default is trial onset (\code{NULL})}

\item{\code{...}}{passed to \code{\link{RAVESubjectEpochRepository}} constructor}

\item{\code{quiet}}{see field \code{quiet}}

\item{\code{repository_id}}{see field \code{repository_id}}

\item{\code{strict}}{whether the mode should be strict; default is true and
errors out when subject is missing}

\item{\code{lazy_load}}{whether to delay calling \code{mount_data};
default is false}

\item{\code{reference_name}}{ignored, always \code{'noref'} for raw voltage
data}

\item{\code{.class}}{internally used, do not set, even if you know what this is}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochRawVoltageRepository-mount_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochRawVoltageRepository-mount_data}{}}}
\subsection{Method \code{mount_data()}}{
function to mount raw voltage signals
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochRawVoltageRepository$mount_data(
  ...,
  force = TRUE,
  electrodes = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{reserved}

\item{\code{force}}{force update data; default is true}

\item{\code{electrodes}}{electrodes to update for expert-use use; default is
\code{NULL} (all electrode channels will be mounted)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochRawVoltageRepository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochRawVoltageRepository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochRawVoltageRepository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
