% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or_size.R
\name{or_size}
\alias{or_size}
\title{Sample Size or Power for Odds Ratio Test}
\usage{
or_size(
  pA,
  pB,
  delta = NULL,
  kappa = 1,
  alpha,
  beta = NULL,
  nB = NULL,
  test_type = "equality"
)
}
\arguments{
\item{pA}{Numeric. True proportion of group A.}

\item{pB}{Numeric. True proportion of group B.}

\item{delta}{Numeric (optional). Margin for \code{"non-inferiority"} or \code{"equivalence"} test. Required for \code{"non-inferiority"} or \code{"equivalence"} test.}

\item{kappa}{Numeric. Ratio of sample sizes (nA/nB). Default is 1.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{nB}{Integer (optional). Sample size for group B. Required for power calculation.}

\item{test_type}{Character. \code{"equality"}, \code{"non-inferiority"}, or \code{"equivalence"}. Default is \code{"2-side"}.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{nB} is given).
}
\description{
Calculates sample size or power for odds ratio test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{nB} (for power calculation) should be specified.

Required arguments by \code{test_type}:
\itemize{
\item \code{"equality"}:
\itemize{
\item For sample size: \code{pA}, \code{pB}, \code{alpha}, \code{beta}
\item For power: \code{pA}, \code{pB}, \code{alpha}, \code{nB}
}
\item \code{"non-inferiority"}/\code{"equivalence"}:
\itemize{
\item For sample size: \code{pA}, \code{pB}, \code{delta},  \code{alpha}, \code{beta}
\item For power: \code{pA}, \code{pB}, \code{delta}, \code{alpha}, \code{nB}
}
}
}
\examples{
# Sample size for `"equality"` test
or_size(pA = 0.4, pB = 0.25, kappa = 1,
        alpha = 0.05, beta = 0.2, test_type = "equality")

# Power of `"equality"` test
or_size(pA = 0.4, pB = 0.25, kappa = 1,
        alpha = 0.05, nB = 156, test_type = "equality")

# Sample size for `"non-inferiority"` test
or_size(pA = 0.4, pB = 0.25, delta = 0.2, kappa = 1,
        alpha = 0.05, beta = 0.2, test_type = "non-inferiority")

# Power of `"non-inferiority"` test
or_size(pA = 0.4, pB = 0.25, delta = 0.2, kappa = 1,
        alpha = 0.05, nB = 242, test_type = "non-inferiority")

# Sample size for `"equivalence"` test
or_size(pA = 0.25, pB = 0.25, delta = 0.5, kappa = 1,
        alpha = 0.05, beta = 0.2, test_type = "equivalence")

# Power of `"equivalence"` test
or_size(pA = 0.25, pB = 0.25, delta = 0.5, kappa = 1,
        alpha = 0.05, nB = 366, test_type = "equivalence")

}
