% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbo.r
\name{ELBOflow}
\alias{ELBOflow}
\title{Evidence Lower Bound (ELBO) for Flow-Based Variational Inference}
\usage{
ELBOflow(flow, Qobs, pxgivenz, nmc = 256)
}
\arguments{
\item{flow}{A flow model created by \code{makeflow()}.}

\item{Qobs}{Observed empirical distribution (probability vector).}

\item{pxgivenz}{A function mapping a latent vector z to a categorical pmf.}

\item{nmc}{Number of Monte Carlo samples.}
}
\value{
A numeric ELBO value.
}
\description{
Computes the ELBO:
}
\details{
\eqn{\log p(x \| z) + \log p(z) - \log q(z)}

where:
\itemize{
\item q(z) is the flow-based variational posterior
\item p(z) is a standard Gaussian prior
\item p(x | z) is provided by the user as \code{pxgivenz}
}

The expectation is approximated via Monte Carlo sampling.
}
\examples{
f <- makeflow("planar", list(u = 0.1, w = 0.2, b = 0))
px <- function(z) c(0.3, 0.4, 0.3)
ELBOflow(f, Qobs = c(0.2, 0.5, 0.3), pxgivenz = px, nmc = 100)

}
