% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{RankControl-class}
\alias{RankControl}
\alias{RankControl-class}
\title{RankControl Class}
\description{
A virtual S4 class to store control parameters for model fitting.
}
\details{
RankControl class must be extended to reflect what distance metric should be used. Possibles extensions are \code{\link{RankControlWeightedKendall}}, \code{\link{RankControlKendall}}, \code{\link{RankControlPhiComponent}},
\code{\link{RankControlWtau}}, \code{\link{RankControlSpearman}}, \code{\link{RankControlFootrule}}, \code{\link{RankControlHamming}}, and \code{\link{RankControlCayley}}.

The control parameters that start with prefix \code{EM_} are intended for the EM iteration. The ones with prefix \code{SeachPi0} control the behaviour of searching model ranking.
}
\section{Slots}{

\describe{
\item{\code{EM_limit}}{maximum number of EM iteration}

\item{\code{EM_epsilon}}{convergence error for weights and cluster probabilities in EM iteration}

\item{\code{SearchPi0_limit}}{maximum number of iterations in the local search of pi0.}

\item{\code{SearchPi0_FUN}}{a function object that gives a goodness of fit criterion. The default is log likelihood.}

\item{\code{SearchPi0_fast_traversal}}{a logical value. If TRUE (by default), immediately traverse to the neighbour if it is better than the current best. Otherwise, check all neighbours and traverse to the best one.}

\item{\code{SearchPi0_show_message}}{a logical value. If TRUE, the location of the current pi0 is shown.}

\item{\code{SearchPi0_neighbour}}{a character string specifying which type of neighbour to use in the local search. Supported values are: "Cayley" to use neighbours in terms of Cayley distance or "Kendall" to use neighbours in terms of Kendall distance.
Note that Kendall neighbours are a subset of Cayley neighbours}
}}
\section{User-defined Criterion}{

You can specify user-defined criterion to choose modal rankings. The function object SearchPi0_FUN takes a list as argument. The components in the list include the following. \code{obs}: the number of observations.
\code{w.est}: the estimated weights. \code{log_likelihood}: the estimated log_likelihood. With this information, most of the popular information criterion can be supported and customized criterion can also be defined.
A larger returned value indicates a better fit. Note that if you are fitting a mixture model the EM algorithm always tries to maximized the log likelihood. Thus the default value should be used in this case.
}
\references{
Qian Z,  Yu L. H. P (2019) "Weighted Distance-Based Models for Ranking Data Using the R Package rankdist." \emph{Journal of Statistical Software}, \strong{90}(5), 1-31. doi: 10.18637/jss.v090.i05
}
\seealso{
\code{\link{RankData}}, \code{\link{RankInit}}
}

