% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_cdf.R
\name{r_cdf}
\alias{r_cdf}
\title{Generate Random Numbers Based on an arbitrary CDF}
\usage{
r_cdf(
  Fun,
  min = -Inf,
  max = Inf,
  ...,
  data = NULL,
  n = default_n(..., data),
  .seed = NULL
)
}
\arguments{
\item{Fun}{function to use as the cdf. See details}

\item{min, max}{range values for the domain of the \code{Fun}}

\item{...}{arguments that can be passed to \code{Fun}}

\item{data}{data set containing arguments to be passed to  \code{Fun}}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates Random Numbers based on a distribution defined by any
arbitrary cumulative distribution function
}
\details{
The \code{Fun} argument accepts \code{purrr} style inputs.
Must be vectorised, defined on the whole Real line and return a
single numeric value between 0 and 1 for any input. The random
variable will be passed to \code{Fun} as the first argument.
This means that R's argument matching can be used with named
arguments in \code{...} if a different positional argument is wanted.
}
\examples{

set_n(5)

my_fun <- function(x, beta = 1) {
  1 - exp(-beta * x)
}

r_cdf(my_fun)


r_cdf(~ 1 - exp(-.x), min = 0)

r_cdf(~ 1 - exp(-.x * beta), beta = 1:10, min = 0)
}
