% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_mixedeff.R
\name{mixedeff}
\alias{mixedeff}
\title{Mixed Effects Models for Rating and Ranking}
\usage{
mixedeff(jpMat, REML = FALSE, ties.method = "average")
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{REML}{a logical value for lme4::lmer}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Mixed Effects Modeling
}
\examples{
jpMat <- c(1,3,5,2,6,4,3,8,7)
attr(jpMat, "dim") <- c(3,3)
mixedeff(jpMat)

}
\references{
Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
