% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_massey.R
\name{massey}
\alias{massey}
\title{Massey's method for Rating and Ranking}
\usage{
massey(jpMat, method = "massey", ties.method = "average")
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying Massey's method, including "massey", "masseyc", "masseynt" and "masseycnt"}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Massey's method, Masseyized Colley method, Massey's method--no ties, Masseyized Colley method--no ties
}
\details{
\enumerate{
\item \code{massey}: Massey's method 
\item \code{masseyc}: Masseyized Colley method
\item \code{masseynt}: Massey's method, no ties
\item \code{masseycnt}: Masseyized Colley method, no ties
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,
byrow=TRUE)
result <- massey(jpMat, method='massey')
print(result)
}
\references{
Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.

Massey, K. (1997). Statistical models applied to the rating of sports teams. Bachelor's Thesis, Blueeld College.
}
\author{
Jiangtao Gou
}
