% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_elo.R
\name{elo}
\alias{elo}
\title{Elo’s Method for Rating and Ranking}
\usage{
elo(
  jpMat,
  method = "elow",
  Kfactor = 32,
  xiparameter = 400,
  initScore = 2000,
  round = 100,
  ties.method = "average"
)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying Elo's method, including "elo", "elow", "elos"}

\item{Kfactor}{a parameter to properly balance the deviation between actual and expected scroes against prior ratings}

\item{xiparameter}{a parameter affects the spread of the reatings in the logistic function}

\item{initScore}{a parameter describe the average rating}

\item{round}{a parameter indicates the number of iterations}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Elo's system
}
\details{
\enumerate{
\item \code{elo}: Elo's system, using win-tie-loss, equivalent to \code{elow}
\item \code{elow}: Elo's system, using win-tie-loss
\item \code{elos}: Elo's system, using game scores (each pair has one pair of scores)
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,
byrow=TRUE)
result <- elo(jpMat, 
method='elow', 
Kfactor=32, 
xiparameter=400, 
initScore=2000, 
round=10, 
ties.method='average')
print(result)
}
\references{
Elo, A. E. (1978). The Rating of Chessplayers, Past and Present. Arco Publishing Company, New York.

Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.
}
\author{
Jiangtao Gou
}
