% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_convertJudgePresenterMatrix.R
\name{convertJudgePresenterMatrix}
\alias{convertJudgePresenterMatrix}
\title{Judge-Presenter Matrix Converter}
\usage{
convertJudgePresenterMatrix(jpMat)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}
}
\value{
A data frame as a long table, where each row is an observation, including the score, the row number and the column number in the \code{jpMat} matrix
}
\description{
Convert a judge-presenter matrix to a data frame with three variables/columns
}
\details{
\enumerate{
 \item \code{score}: nonzero and non-NA scores
 \item \code{row}: array indices 
 \item \code{col}: arry indices
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,
byrow=TRUE)
result <- convertJudgePresenterMatrix(jpMat)
print(result)

}
\author{
Jiangtao Gou

Fengqing Zhang
}
