% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniformflow.R
\name{uniformflow}
\alias{uniformflow}
\title{Create an analytic element with uniform flow}
\usage{
uniformflow(TR, gradient, angle, ...)
}
\arguments{
\item{TR}{numeric, constant transmissivity value used to define the discharge.}

\item{gradient}{numeric, hydraulic gradient. Positive in the direction of flow.}

\item{angle}{numeric, angle of the primary direction of background flow
in degrees counterclockwise from the x-axis.}

\item{...}{ignored}
}
\value{
Analytic element of constant uniform flow which is an object of class \code{uniformflow} and inherits from \code{element}.
}
\description{
\code{\link[=uniformflow]{uniformflow()}} creates an analytic element of constant uniform background flow.
}
\details{
\code{TR} and \code{gradient} are multiplied to obtain the discharge which remains
constant throughout the system, independent of the saturated thickness of the aquifer.

Groundwater flow is always in the direction of the \emph{negative} hydraulic gradient. Note that \code{gradient} is
specified here as positive in the direction of flow for convenience.
}
\examples{
uf <- uniformflow(TR = 100, gradient = 0.002, angle = -45) # South-eastern direction
}
