% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areasink.R
\name{headareasink}
\alias{headareasink}
\title{Create a head-specified area-sink analytic element}
\usage{
headareasink(xc, yc, hc, R, resistance = 0, location = c("top", "base"), ...)
}
\arguments{
\item{xc}{numeric, x location of the center of the area-sink.}

\item{yc}{numeric, y location of the center of the area-sink.}

\item{hc}{numeric, specified hydraulic head at the center of the area-sink.}

\item{R}{numeric, radius of the circular area-sink.}

\item{resistance}{numeric, hydraulic resistance of the area-sink at its connection with the aquifer. Defaults to 0 (no resistance).}

\item{location}{character, either \code{top} (default) or \code{base} specifying the vertical position of the area-sink.}

\item{...}{ignored}
}
\value{
Circular head-specified area-sink analytic element which is an object of class \code{headareasink} and inherits from \code{areasink}.
}
\description{
\code{\link[=headareasink]{headareasink()}} creates a circular area-sink analytic element with constant specified head. The constant leakage flux
into or out of the aquifer from the area-sink is computed by solving the corresponding \code{aem} model.
}
\details{
The constant leakage flux from the area-sink is computed by solving the \code{aem} model given
the specified head \code{hc} for the area-sink. This head is located at the so-called collocation point,
which is placed at the center of the area-sink. A positive flux is into the aquifer. Note that this head-dependent
flux is constant over the domain and computed only at the collocation point. The flux is therefore determined
by the difference in aquifer head and specified head at that location only, and does not vary across the domain with
varying aquifer head.

The resistance can be increased for a area-sink in poor connection with the aquifer, e.g. because of
a confining unit of low hydraulic conductivity between the aquifer and the area-sink. If the aquifer is unconfined
(i.e. has a variable saturated thickness), the system of equations will then become non-linear with respect to the hydraulic
head and iteration is required to solve the model.
}
\examples{
has <- headareasink(xc = -500, yc = 0, hc = 3, R = 500, res = 1000)
has <- headareasink(xc = -500, yc = 0, hc = 3, R = 500, location = 'base')

}
\seealso{
\code{\link[=areasink]{areasink()}}
}
