% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_slides.R
\name{show_slides}
\alias{show_slides}
\title{Preview slide deck from a package}
\usage{
show_slides(package = NULL, deck = NULL, ...)
}
\arguments{
\item{package}{Character. Provide the package containing one or more slide decks.}

\item{deck}{Character. The name of the slide deck to render without ".qmd".}

\item{...}{Optional arguments passed to \code{quarto::quarto_preview()}.}
}
\description{
Render a Quarto slide deck from the supplied package in the Viewer or browser.
For more information look in the
\href{../doc/ah_write_slides.html}{Creating Slides with write_slides()} vignette.
}
\note{
Uses \code{quarto::quarto_preview()} to display the slide deck in the
Viewer pane or browser.
}
\examples{
if (interactive()) {
  # Preview a known slide deck name from a package:
  show_slides(package = "rUM", deck = "rUM_the_package")

  # Use find_slides to pipe the output:
  find_slides(package = "rUM") |> show_slides()
}

}
