% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTensor_Class.R
\docType{methods}
\name{k_unfold-methods}
\alias{k_unfold-methods}
\alias{k_unfold}
\alias{k_unfold,Tensor-method}
\title{Tensor k-mode Unfolding}
\usage{
k_unfold(tnsr, m)

\S4method{k_unfold}{Tensor}(tnsr, m = NULL)
}
\arguments{
\item{tnsr}{the Tensor instance}

\item{m}{the index of the mode to unfold on}
}
\value{
matrix with \code{x@modes[m]} rows and \code{prod(x@modes[-m])} columns
}
\description{
Unfolding of a tensor by mapping the kth mode (specified through parameter \code{m}), and all other modes onto the column space. This the most common type of unfolding operation for Tucker decompositions and its variants. Also known as k-mode matricization.
}
\details{
\code{k_unfold(tnsr,m=NULL)}
}
\examples{
tnsr <- rand_tensor()
matT2<-rs_unfold(tnsr,m=2)
}
\references{
T. Kolda and B. Bader, "Tensor decomposition and applications". SIAM Applied Mathematics and Applications 2009.
}
\seealso{
\code{\link{matvec-methods}} and \code{\link{unfold-methods}}
}
