% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.functions.R
\name{matern.rational.cov}
\alias{matern.rational.cov}
\title{Rational approximation of the Matern covariance}
\usage{
matern.rational.cov(
  h,
  order,
  kappa,
  nu,
  sigma,
  type_rational = "brasil",
  type_interp = "linear"
)
}
\arguments{
\item{h}{Distances to compute the covariance for}

\item{order}{The order of the approximation}

\item{kappa}{Range parameter}

\item{nu}{Smoothness parameter}

\item{sigma}{Standard deviation}

\item{type_rational}{Method used to compute the coefficients of the rational approximation.}

\item{type_interp}{Interpolation method for the rational coefficients.}
}
\value{
The covariance matrix of the approximation
}
\description{
Computes a rational approximation of the Matern covariance function on intervals.
}
\examples{
h <- seq(from = 0, to = 1, length.out = 100)
cov.true <- matern.covariance(h, kappa = 10, sigma = 1, nu = 0.8)
cov.approx <- matern.rational.cov(h, kappa = 10, sigma = 1, nu = 0.8, order = 2)

plot(h, cov.true)
lines(h, cov.approx, col = 2)
 
}
