% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safely_transform_continuous.R
\name{safely_transform_continuous}
\alias{safely_transform_continuous}
\title{Calculating a Transformation of a Continuous Feature Using PDP/ALE Plot}
\usage{
safely_transform_continuous(
  explainer,
  variable,
  response_type = "ale",
  grid_points = 50,
  N = 200,
  penalty = "MBIC",
  nquantiles = 10,
  no_segments = 2
)
}
\arguments{
\item{explainer}{DALEX explainer created with explain() function}

\item{variable}{a feature for which the transformation function is to be computed}

\item{response_type}{character, type of response to be calculated, one of: "pdp", "ale".
If features are uncorrelated, one can use "pdp" type - otherwise "ale" is strongly recommended.}

\item{grid_points}{number of points on x-axis used for creating the PD/ALE plot, default 50}

\item{N}{number of observations from the dataset used for creating the PD/ALE plot, default 200}

\item{penalty}{penalty for introducing another changepoint,
one of "AIC", "BIC", "SIC", "MBIC", "Hannan-Quinn" or numeric non-negative value}

\item{nquantiles}{the number of quantiles used in integral approximation}

\item{no_segments}{numeric, a number of segments variable is to be divided into in case of founding no breakpoints}
}
\value{
list of information on the transformation of given variable
}
\description{
The safely_transform_continuous() function calculates a transformation function
for the continuous variable using a PD/ALE plot obtained from black box model.
}
\examples{

library(DALEX)
library(randomForest)
library(rSAFE)

data <- apartments[1:500,]
set.seed(111)
model_rf <- randomForest(m2.price ~ construction.year + surface + floor +
                           no.rooms + district, data = data)
explainer_rf <- explain(model_rf, data = data[,2:6], y = data[,1])
safely_transform_continuous(explainer_rf, "construction.year")

}
\seealso{
\code{\link{safe_extraction}}, \code{\link{safely_detect_changepoints}}
}
