% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safely_detect_changepoints.R
\name{safely_detect_changepoints}
\alias{safely_detect_changepoints}
\title{Identifying Changes in a Series Using PELT Algorithm}
\usage{
safely_detect_changepoints(data, penalty = "MBIC", nquantiles = 10)
}
\arguments{
\item{data}{a vector within which you wish to find changepoints}

\item{penalty}{penalty for introducing another changepoint,
one of "AIC", "BIC", "SIC", "MBIC", "Hannan-Quinn" or numeric non-negative value}

\item{nquantiles}{the number of quantiles used in integral approximation}
}
\value{
a vector of optimal changepoint positions (last observations of each segment)
}
\description{
The safely_detect_changepoints() function calculates the optimal positioning
and number of changepoints for given data and penalty. It uses a PELT algorithm
with a nonparametric cost function based on the empirical distribution.
The implementation is inspired by the code available on https://github.com/rkillick/changepoint.
}
\examples{

library(rSAFE)

data <- rep(c(2,7), each=4)
safely_detect_changepoints(data)

set.seed(123)
data <- c(rnorm(15, 0), rnorm(20, 2), rnorm(30, 8))
safely_detect_changepoints(data)
safely_detect_changepoints(data, penalty = 25)
}
\seealso{
\code{\link{safely_transform_continuous}}
}
