% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corPs.R
\name{corPs}
\alias{corPs}
\title{Calculate pairwise p-value}
\usage{
corPs(pm1, pm2, type = c("Mat", "Vec"), pthresh = 0.05)
}
\arguments{
\item{pm1, pm2}{Subsets of two omics data sets where rows are the features and columns are samples.
The rows of the two matrices would define the two-way feature set of interest.}

\item{type}{Two options are available. Mat: Calculate the correlation of subsets and return a
matrix; Vec: calculate the correlation matrix, subset by the given threshold and return a
vector of p-values.}

\item{pthresh}{Only relevant for type="Vec". The threshold by which the p-values are filtered (p>pthresh is removed).
Default value is 0.05.}
}
\value{
Either a matrix or vector of pairwise p-values, as indicated by \code{type} parameter.
}
\description{
Calculates pairwise matrix of p-values based on Pearson's correlation test for two matrices.
To gain speed and manage RAM usage, the matrices are split into several smaller chunks.
}
\examples{

#number of subjects
n<-30
#number of features from omic1 in pathway
n_rows<-20
#number of features from omic2 in pathway
n_cols<-30

#random datasets
set.seed(1258)
pm1<-matrix(runif(n_rows*n, min=0, max=1)^8, nrow=n_rows, ncol=n)
pm2<-matrix(runif(n_rows*n, min=0, max=1)^8, nrow=n_rows, ncol=n)

#calculate correlation matrix
pmat<-corPs(pm1, pm2, type="Mat")

pmat

}
