% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ilwt.R
\name{ilwt}
\alias{ilwt}
\title{Inverse Lifting Wavelet Transform ('C++' Accelerated)}
\usage{
ilwt(lwt_obj, scheme = NULL)
}
\arguments{
\item{lwt_obj}{Object of class 'lwt' returned by \code{lwt()}.}

\item{scheme}{(Optional) \code{lifting_scheme} object.
If NULL, uses the one from \code{lwt_obj}.}
}
\value{
Numeric vector containing the reconstructed signal.
}
\description{
Reconstructs the original signal from wavelet coefficients.
Optimized with 'C++' backend.
}
\examples{
s = c(1, 2, 3, 4)
sch = lifting_scheme("haar")
fwd = lwt(s, sch)
rec = ilwt(fwd)
print(rec) # Should match s
}
