% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy-rules.R
\name{infer_rules}
\alias{infer_rules}
\title{Make the inference}
\usage{
infer_rules(rules, operator, input)
}
\arguments{
\item{rules}{the set of fuzzy rules.}

\item{operator}{the \code{\link{operator}} object.}

\item{input}{is the list of validity degrees related to the input \code{\link{cp}} objects.}
}
\value{
A vector that containd the result of the inference.
}
\description{
Make an inference with the fuzzy rules.
}
\examples{
## In the example the input of the fuzzy rule correspond with two CPs and each CP has 3
## linguistic variables, e.g, {"bad", "good", "very good"}. The output also
## correspond with a CP with 3 linguistic variables.

 infer_rules(fuzzy_rules(fuzzy_rule(0,0,1, 0,0,1, 0,0,1),
                   fuzzy_rule(1,0,0, 1,0,0, 1,0,0),
                   fuzzy_rule(0,1,0, 0,1,0, 0,1,0)),
             operator(min, max),
             list(c(0,0.5,0.5),c(0.5,0.5,0)))
## [1] 0.0 0.5 0.0
}
