% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/java_valid_versions.R
\name{java_valid_major_versions_corretto}
\alias{java_valid_major_versions_corretto}
\title{Get Available Online Versions of Amazon Corretto}
\usage{
java_valid_major_versions_corretto(
  arch = NULL,
  platform = NULL,
  imageType = "jdk"
)
}
\arguments{
\item{arch}{Optional character string for the target architecture (e.g., "x64").
If \code{NULL}, it is inferred using \code{platform_detect()}.}

\item{platform}{Optional character string for the operating system (e.g., "windows", "macos", "linux").
If \code{NULL}, it is inferred using \code{platform_detect()}.}

\item{imageType}{Optional character string to filter on; defaults to \code{"jdk"}. Can be set to \code{"jre"} for Windows Java Runtime Environment.}
}
\value{
A \code{character} vector of available major Corretto versions.
}
\description{
This function downloads the latest Amazon Corretto version information from the
Corretto GitHub endpoint and returns a data frame with details for all eligible releases.
}
\details{
It leverages the existing \code{platform_detect()} function to infer the current operating
system and architecture if these are not provided.
}
\keyword{internal}
